#-------------------------------------------------------------------------------
# Name:        Main
# Purpose:
# version 1
# Author:    Shimako  2015
           
# version 2
# Modified:  Barna 01/06/2024 

#
#
#-------------------------------------------------------------------------------
import gc
import timeit
import os
# import shutil
import datetime
import csv
import re
import numpy as np
import matplotlib.pyplot as plt


from climate_change_v2 import Climate_change
from substances_classes import Dyplca_substances
from functools import reduce


"""------------------------------------------------------------------------------
# Parameters for the calculation of the dynamic LCIA methods
#
# User should input the desired parameters for dynamic LCIA calculation hereafter
# Parameters that can be changed are:
#    - dyplca_file_name (string): name of the DyPLCA file to be assessed
#    - span_time_cc (float): span time for climate change calculation
#    - the time step of the inventory (years)
#   
#  parameter i.emission should be adapted to the input file, 
#  depending on the measure (kg, or kg/year)
#------------------------------------------------------------------------------"""
 

dyplca_params = {'dyplca_file_name' : 'test2methane',
                 'span_time_cc' :20, # year (span time in the future- climate change is calculated from now on '50' years)             
                 'step_size_cc' : 1, # year (results step size - climate change)
                
                 'cc_aggregation_dlci_step' : 'step_size_cc', # year
                 }

        
class Dyplca_general(object):
    """
    Class for the dyplca dlci

    """
    def __init__(self,args):
        self.path = args['path']
        self.name = args['name']
        self.substances =[]
        self.date = []
        self.time = []
        
        try:
            self._import_dyplca()
        except:
            print("There is no file named '" + self.name + "' in the main folder")
            exit()
        self.current_dlci_adapatation()

    def _add_substance(self, substances_dict):
        """
        Add substance to the substance vector in the project class

        parameters
        ----------
            substances_dict (dict) : it contains the data corresponding to a dlci
            substance
        """
        self.substances.append(Dyplca_substances(substances_dict))

    def _split_name(self,name):
        """
        Split DyPLCA header in substance name, compartment and subcompartment
        to return it in a dictionary

        parameters
        ----------
            name (string) : it comes from DyPLCA and contain substance name,
            compartment and subcompartment in one string

        returns
        -------
            dict : name, compartment and subcompartment of dlci header
        """
        splitted_name = re.split(r'[(]', name)
        splitted_name2 = re.split(r'[/)]', splitted_name[1])
        return {'name':splitted_name [0][:-1],
                'compartment':splitted_name2 [0],
                'subcompartment':splitted_name2 [1]}
    
    

    def _import_dyplca (self):
        """
        Import DyPLCA dlci file
        """

        new_ = True # new template


        currentdir = os.path.dirname(os.path.dirname(os.path.abspath(self.path['general'])))
        opendir = open(currentdir + "\\" + self.name + ".csv", "r") # read DLCI file

        if new_:

            reader = csv.reader(opendir, delimiter=",")
            raw_file = list(reader)
            # transpose file to put in alphabetical order
            self.date = raw_file[0][5:] # calendar date vector of project
            self.time = raw_file[1][5:]   # time points
            self.time = [(float(x)) for x in self.time] # time vector of project

            
            del raw_file [2], raw_file[1], raw_file[0]

            for i in raw_file:
                subs = i[0]
                comp = i[1]
                subcomp = i[2]
                emission = [(float(x) if x else 0.0) for x in i[5:]]
                self._add_substance({'name':subs,
                                    'compartment':comp,
                                    'subcompartment':subcomp,
                                    'emission':emission})
        else:
            reader = csv.reader(opendir, delimiter=',')
            raw_file = list(reader)
            # transpose file to put in alphabetical order
            transposed_file = list(map(lambda *row:
                                  [elem or '0.0' for elem in row],
                                  *raw_file))
            self.date = transposed_file[0][1:] # date vector of project
            self.time = transposed_file[1][1:] # time vector of project
            sorted_file = transposed_file[2:]
            for x in sorted_file:
                y = self._split_name(x[0])
                x = x[1:]
                emission = []
                for i in range (len(x)):
                    emission.append(float(x[i]))
                self._add_substance({'name':y['name'],
                                    'compartment':y['compartment'],
                                    'subcompartment':y['subcompartment'],
                                    'emission':emission})
            print(type(emission))
        

    def current_dlci_adapatation(self):
        deltat = (self.time[-1]-self.time[0])/(len(self.time)-1)
        for i in self.substances:
     #       i.emission = [a/deltat for a in i.emission]  # données d'entrée en kg
          
            i.emission = [a for a in i.emission]  # données d'entrée en kg/year
           

    def aggregate_values(self,delta_t):

            delta_t_calc = delta_t

            return delta_t_calc



def main(dyplca_params):

    """
    Runs the importation of DLCI and the chosen DLCIA models

    parameters
    ----------
        dyplca_params (dict) : parameters for running the dynamic DLCIA models
    """
    currentdir = os.path.dirname(os.path.dirname(os.path.abspath("__file__")))
    # parameters_dyplca = Dyplca_params()
   # parameters_dyplca = dyplca_params

    # parameters for climate change calculation
    time_horizon_cc = dyplca_params['span_time_cc'] # years (horizon time)
    discretization_interval_cc = dyplca_params['step_size_cc'] # years (discretization step)
    cc_aggregation_dlci_step = dyplca_params['cc_aggregation_dlci_step']

   
    
    # creation of folders for the results
    path = _create_project_folder(dyplca_params['dyplca_file_name'])
   
    path_cc, path_graph_cc = _create_folder('cc',path)
   
    paths = {'cc':path_cc, 'g_cc':path_graph_cc,
             'general':path}
    
    
    # import DLCI file
    dyplca = {'path': paths,'name': dyplca_params['dyplca_file_name']}
    project = Dyplca_general(dyplca)

    
    #--------------------------------------------------------------------------
    # impacts calculation
    #--------------------------------------------------------------------------
    # climate change
    time_cc = None
   
    start1 = timeit.default_timer() # start counting the calculation time
        # call the climate change class for calculation
    cc_results = Climate_change(project,
                                    time_horizon_cc,
                                    discretization_interval_cc = discretization_interval_cc,
                                    cc_aggregation_dlci_step = cc_aggregation_dlci_step)
    
    cc_results.climate_change_main() # calculation

    stop1 = timeit.default_timer()
    time_cc = time_spent(start1,stop1,'cc') # calculation of time spent

    write_csv_time = ['time climate change',time_cc]
    with open(paths['general'] + 'time_calculation.csv', 'w') as fp:
        a = csv.writer(fp,delimiter = ',', lineterminator = '\n')
        a.writerows(write_csv_time)

# ------------------------------------------------------------------------------
# The following methods are only used for the support of this module
# ------------------------------------------------------------------------------

def _create_project_folder (name):
    """ create a folder for the project """
    currentdir = os.path.dirname(os.path.dirname(os.path.abspath("__file__")))
    now = datetime.datetime.now()
    time_file = str(now.day) + str(now.month) + str(now.year) + str(now.hour) \
              + str(now.minute) + '_'
    newpath = currentdir + '\\results\\' + name + '_' + time_file + '\\'
    try:
        os.makedirs(newpath)
        return newpath
    except:
        print('path already exists, interval of creation between two simulations was short')
        exit()

def _create_folder(category,_path):
    """ create a folder for dlcia method results """
    if category == 'cc':
        path = _path + 'cc\\'
        os.makedirs(path)
        path_graph = path + 'graphics\\'
        os.makedirs(path_graph)
        os.makedirs(path_graph+'substances')

    return path, path_graph

def time_spent(start,stop,name):
        """ calculation of time spent the calculation of a dlcia category """
        time_tot = stop-start
        s = int(time_tot%60)
        m_ = int(time_tot/60)
        m = m_%60
        h = int(m_/60)
        x = (h,m,s)
        print('time spent ' + name + ': %s h %s m %s s' %x)
        return '%s h %s m %s s' %x

##def interface (args):
##    parameters_dyplca =

if __name__ == '__main__':
    
    
    main(dyplca_params)







